;********************************************************************
;                      .
;                    http:\\pic16f84.narod.ru
;             
;**********************************************************************
; 29.1.2002

;-    :
; 1)   17 ;
; 2)  8x6;
; 3)  12x9;
; 4)   8x6;
; 5)    2x2;
; 6)  .
; 
;-    ( 1) 
;   ( RB1).
;-       1,  
;  ( PIC    SLEEP ). 
;- ,    ,   .


;       :
;
;00       20 20 20 20 20 20 20 20      _ _ _ _ _ _ _ _
;08       20 60 48 50 90 58 20 20      _      _ _
;10       20 20 20 88 90 E8 88 20      _ _ _     _
;18       20 D8 20 00 58 98 90 08      _ 6 _      
;20       10 18 18 A0 A8 B0 B0 20      h t t p : \ \ _
;28       A0 B8 68 C8 D8 70 E0 D0      p i c 1 6 f 8 4
;30       20 40 78 80 28 30 38 20      _ . n a r o d _
;38       20 20 40 28 C0 20 20 20      _ _ . r u _ _ _

;  :
;           oscillator  -  HS
;           power       -  on
;           wach        -  off
;           code protect - off

;*******************************************************************

  
; p pp
pcl		equ	0x02
status		equ	0x03
indf		equ	0x00
fsr		equ	0x04
eedata		equ	0x08
eeadr		equ	0x09
eecon1		equ	0x08
TRISA           EQU     85h
TRISB           EQU     86h

; 
porta		equ	0x05
portb		equ	0x06

;  
counter0	equ	0x12
counter1	equ	0x13
counter2	equ	0x14
videostuff	equ	0x15
line		equ	0x16
cnt1            equ	0x17
cnt2            equ	0x18
delaycnt	equ	0x19
counter3        equ	0x20
cnt7            equ	0x21
strptr		equ	0x22
stringbuff	equ	0x24
cnt3            equ	0x25
cnt4            equ	0x26
cnt5            equ	0x27
cnt6            equ	0x28


knop1           EQU     0Ch     ;C 
regim           EQU     0Dh     ;  
time            EQU     0Eh     ;  

; 
w		equ	0
f		equ	1

;  pp STATUS
rp0		equ	5
z		equ	0

;  pp EECON1
rd		equ	0

;  pp knop1
sostoynie       equ	0


;*******************************************************************

delay		MACRO
		LOCAL	label
		movwf	delaycnt
label		decfsz	delaycnt
		goto label
		ENDM

dnop		MACRO
		LOCAL	label
label		goto	label+1
		ENDM

;*******************    **********************
; 
        ORG     0
       GOTO    INIT

;*********   **********************
table  ;    
                addwf	pcl,f
;    0x0
		retlw 0x7F      ;.
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x77      ;..
;    0x8
		retlw 0xEB      ;..
		retlw 0x6A      ;....
		retlw 0x52      ;.....
		retlw 0x52      ;.....
		retlw 0x4A      ;.....
		retlw 0x4A      ;.....
		retlw 0x46      ;.....
		retlw 0xE3      ;...
;h    0x10
		retlw 0x03      ;......
		retlw 0x02      ;.......
		retlw 0x1A      ;.....
		retlw 0x26      ;.....
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x77      ;..
;t    0x18
		retlw 0x04      ;.......
		retlw 0x04      ;.......
		retlw 0x3E      ;...
		retlw 0x04      ;.......
		retlw 0x04      ;.......
		retlw 0x04      ;.......
		retlw 0x44      ;......
		retlw 0x38      ;.....
;    0x20
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
;r     0x28
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x76      ;...
		retlw 0x4C      ;.....
		retlw 0x04      ;.......
		retlw 0x04      ;.......
		retlw 0x04      ;.......
		retlw 0x3F      ;..
;o     0x30
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x1C      ;.....
		retlw 0x22      ;......
		retlw 0x41      ;......
		retlw 0x41      ;......
		retlw 0x22      ;......
		retlw 0x1C      ;.....
;b     0x38
		retlw 0x30      ;......
		retlw 0x20      ;.......
		retlw 0x2C      ;.....
		retlw 0x32      ;.....
		retlw 0x21      ;......
		retlw 0x21      ;......
		retlw 0x32      ;.....
		retlw 0x6C      ;....
;.     0x40
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x18      ;......
		retlw 0x18      ;......
;     0x48
		retlw 0xE7      ;..
		retlw 0x62      ;.....
		retlw 0x52      ;.....
		retlw 0x52      ;.....
		retlw 0x4A      ;.....
		retlw 0x4A      ;.....
		retlw 0x46      ;.....
		retlw 0xE3      ;...
;     0x50
		retlw 0x7E      ;..
		retlw 0x24      ;......
		retlw 0x24      ;......
		retlw 0x24      ;......
		retlw 0x24      ;......
		retlw 0x22      ;......
		retlw 0x7F      ;.
		retlw 0x41      ;......
;O     0x58
		retlw 0x1C      ;.....
		retlw 0x22      ;......
		retlw 0x41      ;......
		retlw 0x41      ;......
		retlw 0x41      ;......
		retlw 0x41      ;......
		retlw 0x22      ;......
		retlw 0x1C      ;.....
;B     0x60
		retlw 0x3F      ;..
		retlw 0x42      ;......
		retlw 0x42      ;......
		retlw 0x3E      ;...
		retlw 0x22      ;......
		retlw 0x42      ;......
		retlw 0x42      ;......
		retlw 0x3F      ;..
;c     0x68
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x7C      ;...
		retlw 0x42      ;......
		retlw 0x02      ;.......
		retlw 0x02      ;.......
		retlw 0x42      ;......
		retlw 0x3C      ;....
;f     0x70
		retlw 0x78      ;....
		retlw 0x04      ;.......
		retlw 0x3E      ;...
		retlw 0x04      ;.......
		retlw 0x04      ;.......
		retlw 0x04      ;.......
		retlw 0x04      ;.......
		retlw 0x3E      ;...
;n     0x78
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x1B      ;....
		retlw 0x26      ;.....
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x77      ;..
;a     0x80
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x1E      ;....
		retlw 0x20      ;.......
		retlw 0x3E      ;...
		retlw 0x21      ;......
		retlw 0x31      ;.....
		retlw 0x6E      ;...
;     0x88
		retlw 0x7F      ;.
		retlw 0x49      ;.....
		retlw 0x49      ;.....
		retlw 0x08      ;.......
		retlw 0x08      ;.......
		retlw 0x08      ;.......
		retlw 0x08      ;.......
		retlw 0x3E      ;...
;     0x90
		retlw 0x7F      ;.
		retlw 0x42      ;......
		retlw 0x12      ;......
		retlw 0x1E      ;....
		retlw 0x12      ;......
		retlw 0x02      ;.......
		retlw 0x42      ;......
		retlw 0x7F      ;.
;     0x98
		retlw 0xFE      ;.
		retlw 0x44      ;......
		retlw 0x44      ;......
		retlw 0x44      ;......
		retlw 0x44      ;......
		retlw 0x44      ;......
		retlw 0x45      ;.....
		retlw 0xE3      ;...
;p     0xA0
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x3F      ;...
		retlw 0x42      ;......
		retlw 0x42      ;......
		retlw 0x3E      ;...
		retlw 0x02      ;.......
		retlw 0x0F      ;....
;:     0xA8
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x18      ;......
		retlw 0x18      ;......
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x18      ;......
		retlw 0x18      ;......
;\     0xB0
		retlw 0x20      ;.......
		retlw 0x20      ;.......
		retlw 0x10      ;.......
		retlw 0x08      ;.......
		retlw 0x08      ;.......
		retlw 0x04      ;.......
		retlw 0x02      ;.......
		retlw 0x02      ;.......
;i     0xB8
		retlw 0x08      ;.......
		retlw 0x00      ;........
		retlw 0x0E      ;.....
		retlw 0x08      ;.......
		retlw 0x08      ;.......
		retlw 0x08      ;.......
		retlw 0x08      ;.......
		retlw 0x3E      ;...
;u     0xC0
		retlw 0x00      ;........
		retlw 0x00      ;........
		retlw 0x33      ;....
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x22      ;......
		retlw 0x32      ;.....
		retlw 0x6C      ;....
;1     0xC8
		retlw 0x18      ;......
		retlw 0x1C      ;.....
		retlw 0x18      ;......
		retlw 0x18      ;......
		retlw 0x18      ;......
		retlw 0x18      ;......
		retlw 0x18      ;......
		retlw 0x7E      ;..
;4    0xD0
		retlw 0x38      ;.....
		retlw 0x3C      ;....
		retlw 0x36      ;....
		retlw 0x33      ;....
		retlw 0x7F      ;.
		retlw 0x30      ;......
		retlw 0x30      ;......
		retlw 0x78      ;....
;6     0xD8
		retlw 0x1C      ;.....
		retlw 0x06      ;......
		retlw 0x03      ;......
		retlw 0x3F      ;..
		retlw 0x63      ;....
		retlw 0x63      ;....
		retlw 0x63      ;....
		retlw 0x3F      ;..
;8     0xE0
		retlw 0x3E      ;...
		retlw 0x63      ;....
		retlw 0x63      ;....
		retlw 0x3E      ;...
		retlw 0x63      ;....
		retlw 0x63      ;....
		retlw 0x63      ;....
		retlw 0x3E      ;...
;C     0xE8
		retlw 0x5C      ;....
		retlw 0x62      ;.....
		retlw 0x42      ;......
		retlw 0x02      ;.......
		retlw 0x02      ;.......
		retlw 0x02      ;.......
		retlw 0x44      ;......
		retlw 0x38      ;.....

;************************************

main                  
       call    knopka  ;  
       movf    regim,0 
       addwf   pcl,f   ;  ("regim") 
       goto    tecst   ;       
       goto    setca   ;   8x6
       goto    setca1  ;   12x9
       goto    chess   ;    
       goto    chess1  ;   
       goto    beloe   ; 


;**************   2x2  300  ******************
chess1
        movlw   0x96     ; 150 
        movwf   cnt7
kk
        call    lll1     ;   +  

        decfsz  cnt7,1
        goto kk

        movlw   0x96     ; 150 
        movwf   cnt7
kk1
        call    lll2     ;   +  

        decfsz  cnt7,1
        goto kk1

	bsf	porta,1   ;  
        call    vertsync  ;  
	bcf	porta,1   ;  

        goto main

;**************   300  ***************************
beloe
        movlw   0x02     ;2 
        movwf   cnt5
mm1
        movlw   0x96     ;150 
        movwf   cnt6
mm
        call    llll     ;    

        decfsz  cnt6,1
        goto mm

        decfsz  cnt5,1
        goto mm1

	bsf	porta,1   ;  
        call    vertsync  ;  
	bcf	porta,1   ;  

        goto main

;**************   8x6 300  **********************
chess
        movlw   0x03     ;3 
        movwf   cnt3

mc0
        call    llll     ;    

        movlw   0x31     ;49 
        movwf   cnt4

mc1
        call    stka1

        decfsz  cnt4,1   ; 4 / 
        goto mc1

        call    llll     ;    
        nop

        movlw   0x31     ;49 
        movwf   cnt4

mc2
        call    stka2   ; 4 / 

        decfsz  cnt4,1
        goto mc2

        decfsz  cnt3,1
        goto mc0

	bsf	porta,1   ;  
        call    vertsync  ;  
	bcf	porta,1   ;  

        goto main


;**************  8x6 300  ******************************
setca
        movlw   0x06     ;6 
        movwf   cnt1

m0
        call    llll     ;    
        nop
        nop

        movlw   0x31     ;49 
        movwf   cnt2

m1
        call    stka     ; 9   

        decfsz  cnt2,1
        goto m1

        decfsz  cnt1,1
        goto m0

	bsf	porta,1   ;  
        call    vertsync  ;  
	bcf	porta,1   ;  

        goto main


;**************  12x9 300  *******************************
setca1
	call	blkl     ;   

        movlw   0x09     ;9 
        movwf   cnt1

m2
        call    llll     ;    
        nop
        nop
        nop  

        movlw   0x20     ;32 
        movwf   cnt2

m3
        call    stka12     ; 13   

        decfsz  cnt2,1
        goto m3

        decfsz  cnt1,1
        goto m2

        call    llll      ;    
	call	blkl      ;   

	bsf	porta,1   ;  
        call    vertsync  ;  
	bcf	porta,1   ;  

        goto main


;**************   300  (17  ) **********************
tecst
;1	
		movlw	00h           ; 
		call	printstring
;2
		movlw	00h           ; 
		call	printstring
;3
		movlw	08h           ;
		call	printstring
;4
		movlw	00h           ; 
		call	printstring
;5
		movlw	10h           ;
		call	printstring
;6
		movlw	00h           ; 
		call	printstring
;7
		movlw	18h           ;6 
		call	printstring
;8
		movlw	00h           ; 
		call	printstring
;9
		movlw	00h           ; 
		call	printstring

;10
		movlw	20h           ;http:\\
		call	printstring
;**
;11
		movlw	00h           ; 
		call	printstring
;12
		movlw	28h           ;pic16f84
		call	printstring
;13
		movlw	00h           ; 
		call	printstring
;14
		movlw	30h           ;.narod
		call	printstring
;15
		movlw	00h           ; 
		call	printstring
;16
		movlw	38h           ;.ru
		call	printstring
;17
		movlw	00h           ; 
		call	printstring

		call	blkl          ;   
		call	blkl          ;   
		call	blkl          ;   
		call	blkl          ;   
		call	blkl          ;   
		call	blkl          ;   
		call	blkl          ;   
		call	blkl          ;   
		call	blkl          ;   
		call	blkl          ;   
		call	blkl          ;   


	bsf	porta,1   ;  
        call    vertsync  ;  
	bcf	porta,1   ;  

                goto    main

;***********   ****************************
;  17   (   )
printstring	

     nop
     nop
     nop
                movwf	strptr
		clrf	line
		movlw	0x08        ;8    
		movwf	counter1
printstrl0	bcf	porta,0     ;  
		movlw	0x08
		movwf	counter0    ;8    
		movlw	stringbuff
		movwf	fsr
		movfw	strptr
		movwf	eeadr
		dnop
		dnop
		nop
		bsf	porta,0      ;  
prnstrl1	bsf	status,rp0   ;
		bsf	eecon1,rd    ;  
		bcf	status,rp0   ; 
		movfw	eedata       ; 
		addwf	line,w       ;  
		call	table        ;  
		movwf	indf         ;  
		incf	fsr          ; 
		incf	eeadr        ;
		decfsz	counter0
		goto	prnstrl1
		movlw	0xE          ; 
		delay                ;  
                dnop                 ; 
		incf	line
		bcf	porta,0

		movlw	0x08         ;8    
		movwf	counter0
		movlw	stringbuff
		movwf	fsr
		movlw	2
		delay
		bsf	porta,0      ;  
		movlw	0xD	     ;8    +
		delay                ;+ 14           
prnstrl2	movfw	indf
		movwf	portb        
		rrf	portb        ;  
		rrf	portb        ;  
		rrf	portb
		rrf	portb
		rrf	portb
		rrf	portb
		rrf	portb
		bcf	portb,0
		incf	fsr
		decfsz	counter0
		goto	prnstrl2
		movlw	0x9	      ;14     
		delay
                dnop                  
		decfsz	counter1      ;  8   ?
		goto	printstrl0
		nop
		bcf	porta,0       ;  
		goto	syncret

syncret		movlw	2             ; 4
		delay
		nop
		bsf	porta,0      ;  
		movlw	0x39         ;    
		delay
		return


;***********   ****************************
;  
shortsync	movwf	counter1
shortsync_l0	bcf	porta,0		; 
		bcf	portb,0         ; 
		dnop
		movlw	0x1D		;30 
		movwf	counter2
		nop
		bsf	porta,0         ;  
shortsync_l1	decfsz	counter2
		goto	shortsync_l1
		decfsz	counter1
		goto	shortsync_l0
		retlw	5

;     
vertsync	movlw	5              ;,  
		btfss	videostuff,0   ;   , 
		movlw	6              ;   ,
		call	shortsync      ;   6  5 
		incf	videostuff     ; 

;  
longsync	movwf	counter1
longsync_l0	movlw	0x1D           ;30 
		movwf	counter2       
		bcf	porta,0	       ; 
		bcf	portb,0	       ; 
longsync_l1	decfsz	counter2
		goto	longsync_l1
		nop			
		bsf	porta,0         ;  
		nop                     ;2 
		decfsz	counter1
		goto	longsync_l0

		movlw	5               ;,    
		btfss	videostuff,0    ; ,    ,
		movlw	4               ;   5  4 
		call	shortsync       ; 
		return                   

;********************    ***************************
blkl 
     nop                     ;
     nop                     ;
     nop                     ;
     bcf	porta,0      ; 
     bcf	portb,0      ; 
     movlw 2                 ;
     delay                   ;4

     bsf	porta,0      ;  
     nop
     movlw 38h               ;
     delay                   ;  
     nop                     ;
     return

;********************    ***************************
knopka
     nop                     ;
     nop                     ;
     nop                     ;
     bcf	porta,0      ; 
     bcf	portb,0      ; 
     movlw 2                 ;
     delay                   ;4
     bsf	porta,0      ;  

     btfsc      porta,3           ;     ?
     goto       da0               ;
     btfsc      knop1,sostoynie   ;,       ?
     goto       da1               ;,   ,  - 
     goto       end_knop          ;,      

da1  ;  ,  - 
    bcf        knop1,sostoynie    ;  
    movlw	     32h          ;   
    subwf      time,1             ;  
    btfsc      status,z           ; 1 ?
;    sleep                         ;,  PIC   SLEEP
    call       DOSLEEP
    clrf       time               ;  
    incf       regim,1            ;    1
    movlw      06h                ;   
    subwf      regim,0            ;   5
    btfsc      status,z           ; ,
    clrf       regim              ;  
    goto       end_knop

da0      ;  
   btfsc      knop1,sostoynie     ;             ?
   goto       da2                 ;     
   bsf        knop1,sostoynie     ;   ,      ""
   goto       end_knop   

da2
   incf       time,1              ;    1
   
end_knop

   nop                            ;
   movlw 37h                      ;
   delay                          ;
   nop                            ;
   return



;*************** 9   ************************ 
stka 
     call    nulstr          ;  
     nop
     movlw 08h               ;8 
     movwf counter3          
b0   
     bsf	portb,0	     ;  
     bcf	portb,0	     ;  
     movlw 4                 ;
     delay                   ; 6
     nop
     decfsz counter3         
     goto b0                 
     dnop
     nop
     bsf	portb,0	     ;  
     bcf	portb,0	     ;  
     return



;**************** 13   ********************
stka12 
     call    nulstr          ;  
     nop
     movlw 0Ch               ;12 
     movwf counter3          
b5   
     bsf	portb,0	     ;  
     bcf	portb,0	     ;  
     movlw 2                 ;
     delay                   ; 4
     nop
     decfsz counter3         
     goto b5               
     bsf	portb,0	     ;  
     bcf	portb,0	     ;  
     return


;*******************     ****************************
llll 
     call    nulstr          ;  
     bsf	portb,0	     ;  
     movlw 33h               ;
     delay                   ; 
     dnop                    ;
     return



;******************* 4 /  *************************
stka1
     call    nulstr          ;  
     movlw 04h               ;4 
     movwf counter3          
b02 
     bsf	portb,0	     ;  
     movlw 6                 ;
     delay                   ; 7
     bcf	portb,0	     ;  
     movlw 4                 ;
     delay                   ; 6
     dnop
     decfsz counter3         
     goto b02                
     return


;******************* 4 /  *************
stka2
     call    nulstr          ;  
     movlw 04h               ;4 
     movwf counter3          
b01  
     bcf	portb,0	     ;  
     movlw 6                 ;
     delay                   ; 7
     bsf	portb,0	     ;  
     movlw 4                 ;
     delay                   ; 6
     dnop
     decfsz counter3         
     goto b01                
     return


;**************   +   **********************
lll1 
     call    nulstr          ;  
     nop
     movlw   1Ah             ;
     delay                   ; 29
     nop
     nop
     bsf     portb,0	     ;  
     movlw   19h             ;
     delay                   ; 29
     return

;*******************   +   ****************************
lll2 
     call    nulstr          ;  
     bsf     portb,0	     ;  
     movlw   1Ah             ;
     delay                   ; 29
     nop
     nop
     bcf     portb,0	     ;  
     movlw   19h             ;
     delay                   ; 29
     return


;**********************   *****************************
;*******  4 + 8   *************
nulstr
     bcf	porta,0      ; 
     bcf	portb,0      ; 
     movlw 2                 ;
     delay                   ;4
     bsf	porta,0	     ;  
     movlw 6                 ;
     delay                   ;8
     return

;****************************  **********************
INIT
        BCF     status,rp0    ;  0
        CLRF    porta         ;  
        BSF     status,rp0    ;  1
        MOVLW   B'00001000'   ; 0..2 - ,  3 - 
        MOVWF   TRISA         ;  
        BCF     status,rp0    ;  0
        CLRF    portb         ;  B
        BSF     status,rp0    ;  1
        MOVLW   0             ;    
        MOVWF   TRISB         ;  
        BCF     status,rp0    ;  0
          
        CLRF    knop1         ;  
        CLRF    regim         ;   
        CLRF    time          ;   . 
	bsf	porta,1       ; 
        GOTO    main
;********************************************************************


DOSLEEP
        BCF     status,rp0    ;  0
        CLRF    porta         ;  
        BSF     status,rp0    ;  1
        MOVLW   0             ;    
        MOVWF   TRISA         ;  
        BCF     status,rp0    ;  0
        CLRF    portb         ;  B
        BSF     status,rp0    ;  1
        MOVLW   0             ;    
        MOVWF   TRISB         ;  
        BCF     status,rp0    ;  0
        SLEEP

;
 END
;